/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.provider.Invoker;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Library {
    private static final List<String> userLibraryPath = new CopyOnWriteArrayList<String>();
    private static final Map<String, List<String>> customSearchPaths = new ConcurrentHashMap<String, List<String>>();

    public abstract Invoker getInvoker(Method var1, Map<LibraryOption, ?> var2);

    public abstract Object libraryLock();

    public static String locateLibrary(String string) {
        if (new File(string).isAbsolute()) {
            return string;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(0, com.kenai.jaffl.Library.getLibraryPath(string));
        linkedList.addAll(userLibraryPath);
        String string2 = Platform.getPlatform().locateLibrary(string, linkedList);
        return string2 != null ? string2 : null;
    }

    private static final List<String> getPropertyPaths(String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            String[] stringArray = string2.split(File.pathSeparator);
            return new ArrayList<String>(Arrays.asList(stringArray));
        }
        return Collections.emptyList();
    }

    static {
        userLibraryPath.addAll(Library.getPropertyPaths("jaffl.library.path"));
        userLibraryPath.addAll(Library.getPropertyPaths("jna.library.path"));
    }
}

